<?php
/* --------------------------------------------------------------
  Collection.inc.php 2019-06-07
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

namespace StyleEdit\Collections;

/**
 * Class Collection
 *
 * @package StyleEdit\Collections
 */
class Collection
{
	private $collection = array();
	
	
	/**
	 * Collection constructor.
	 *
	 * @param array $collection
	 */
	public function __construct(array $collection)
	{
		$this->collection = $collection;
	}
	
	
	/**
	 * Returns the collection as an array
	 *
	 * @return array
	 */
	public function toArray()
	{
		return $this->collection;
	}
	
	
	/**
	 * Returns the value of a collection item addressed by the key. If the key is not a string or unknown,
	 * an exception will be thrown.
	 *
	 * @param $p_key
	 *
	 * @throws \InvalidArgumentException if $p_key is not a string
	 * @throws \InvalidArgumentException if $p_key is unknown
	 *
	 * @return mixed
	 */
	public function getItem($p_key)
	{
		if(!is_string($p_key))
		{
			throw new \InvalidArgumentException('$p_key is not a string ($p_key: ' . gettype($p_key) . ')');
		}
		
		if(!array_key_exists($p_key, $this->collection))
		{
			throw new \InvalidArgumentException('$p_key "' . $p_key . '" is unknown');
		}
		
		return $this->collection[$p_key];
	}
	
	
	/**
	 * Get collection item count.
	 *
	 * @return int
	 */
	public function count()
	{
		return sizeof($this->collection);
	}
}